/********************************************
; File: Memory.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __MISCTOOL__
#include <MISCTOOL.h>
#endif

#ifndef __MEMORY__
#define __MEMORY__


/* These are standard memory calls */
char *memccpy(); 
char *memchr(); 
int  memcmp(); 
char *memcpy(); 
char *memset(); 
 


/* Error Codes */
#define memErr 0x0201  /* unable to allocate block */
#define emptyErr 0x0202  /* illegal operation, empty handle */
#define notEmptyErr 0x0203  /* an empty handle was expected for this operation */
#define lockErr 0x0204  /* illegal operation on a locked block */
#define purgeErr 0x0205  /* attempt to purge an unpurgable block */
#define handleErr 0x0206  /* an invalid handle was given */
#define idErr 0x0207  /* an invalid owner ID was given */
#define attrErr 0x0208  /* operation illegal on block with given attributes */

/* Handle Attribute Bits */
#define attrNoPurge 0x0000  /* Not purgeable */
#define attrBank 0x0001  /* fixed bank */
#define attrAddr 0x0002  /* fixed address */
#define attrPage 0x0004  /* page aligned */
#define attrNoSpec 0x0008  /* may not use special memory */
#define attrNoCross 0x0010  /* may not cross banks */
#define attrPurge1 0x0100  /* Purge level 1 */
#define attrPurge2 0x0200  /* Purge level 2 */
#define attrPurge3 0x0300  /* Purge level 3 */
#define attrPurge 0x0300  /* test or set both purge bits */
#define attrHandle 0x1000  /* block of master pointers */
#define attrSystem 0x2000  /* system handle */
#define attrFixed 0x4000  /* not movable */
#define attrLocked 0x8000  /* locked */
extern pascal void AddToOOMQueue() inline(0x0C02,dispatcher);
extern pascal void BlockMove() inline(0x2B02,dispatcher);
extern pascal void CheckHandle() inline(0x1E02,dispatcher);
extern pascal void CompactMem() inline(0x1F02,dispatcher);
extern pascal void DisposeAll() inline(0x1102,dispatcher);
extern pascal void DisposeHandle() inline(0x1002,dispatcher);
extern pascal Handle FindHandle() inline(0x1A02,dispatcher);
extern pascal LongWord FreeMem() inline(0x1B02,dispatcher);
extern pascal LongWord GetHandleSize() inline(0x1802,dispatcher);
extern pascal void HandToHand() inline(0x2A02,dispatcher);
extern pascal void HandToPtr() inline(0x2902,dispatcher);
extern pascal void HLock() inline(0x2002,dispatcher);
extern pascal void HLockAll() inline(0x2102,dispatcher);
extern pascal void HUnlock() inline(0x2202,dispatcher);
extern pascal void HUnlockAll() inline(0x2302,dispatcher);
extern pascal LongWord MaxBlock() inline(0x1C02,dispatcher);
extern pascal void MMBootInit() inline(0x0102,dispatcher);
extern pascal void MMReset() inline(0x0502,dispatcher);
extern pascal void MMShutDown() inline(0x0302,dispatcher);
extern pascal Word MMStartUp() inline(0x0202,dispatcher);
extern pascal Boolean MMStatus() inline(0x0602,dispatcher);
extern pascal Word MMVersion() inline(0x0402,dispatcher);
extern pascal Handle NewHandle() inline(0x0902,dispatcher);
extern pascal void PtrToHand() inline(0x2802,dispatcher);
extern pascal void PurgeAll() inline(0x1302,dispatcher);
extern pascal void PurgeHandle() inline(0x1202,dispatcher);
extern pascal LongWord RealFreeMem() inline(0x2F02,dispatcher);
extern pascal void ReAllocHandle() inline(0x0A02,dispatcher);
extern pascal void RemoveFromOOMQueue() inline(0x0D02,dispatcher);
extern pascal void RestoreHandle() inline(0x0B02,dispatcher);
extern pascal void SetHandleSize() inline(0x1902,dispatcher);
extern pascal void SetPurge() inline(0x2402,dispatcher);
extern pascal void SetPurgeAll() inline(0x2502,dispatcher);
extern pascal LongWord TotalMem() inline(0x1D02,dispatcher);
#endif
